<?php
declare(strict_types=1);
require_once __DIR__ . '/storage.php';

function cust_all(): array { return storage_json_get('customers.json'); }
function cust_save(array $row): int {
    $all = cust_all();
    $id = (int)($row['id'] ?? 0);
    if ($id <= 0) { $id = (int)($all['last_id'] ?? 0) + 1; $row['id']=$id; if(!isset($all['items']))$all['items']=[]; $all['items'][]=$row; }
    else { foreach ($all['items'] as &$it) { if ((int)$it['id'] === $id) { $it = $row; break; } } }
    $all['last_id'] = $id; storage_json_put('customers.json', $all); return $id;
}

function contract_all(): array { return storage_json_get('contracts.json'); }
function contract_create(int $customer_id, string $title, string $amount): int {
    $all = contract_all(); $id = (int)($all['last_id'] ?? 0) + 1;
    $row = ['id'=>$id,'customer_id'=>$customer_id,'title'=>$title,'amount'=>$amount,'status'=>'pending','created_at'=>date('Y-m-d H:i:s')];
    if(!isset($all['items']))$all['items']=[]; $all['items'][]=$row; $all['last_id']=$id; storage_json_put('contracts.json',$all); return $id;
}

function invoice_all(): array { return storage_json_get('invoices.json'); }
function invoice_create(int $customer_id, string $title, string $amount): int {
    $all = invoice_all(); $id = (int)($all['last_id'] ?? 0) + 1;
    $row = ['id'=>$id,'customer_id'=>$customer_id,'title'=>$title,'amount'=>$amount,'status'=>'unpaid','created_at'=>date('Y-m-d H:i:s')];
    if(!isset($all['items']))$all['items']=[]; $all['items'][]=$row; $all['last_id']=$id; storage_json_put('invoices.json',$all); return $id;
}
