<?php
// /handlers/accounting.php — FINAL v1 (ALWAYS SEND + NAV)

declare(strict_types=1);

require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/acc.php';

function vm_ack_cb_if_possible(): void {
    $cb_id = $_POST['callback_query']['id'] ?? null;
    if (!$cb_id && isset($GLOBALS['update']) && is_array($GLOBALS['update'])) {
        $cb_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    }
    if ($cb_id) tg_answer_cb((string)$cb_id, '' , false);
}

function acc_menu(int $uid, int $chat_id = 0, int $mid = 0): void {
    vm_ack_cb_if_possible();
    $rows = [
        [ kb_btn(icon('contract').' ثبت قرارداد سریع', 'acc:contract_quick'),
          kb_btn(icon('invoice').' ثبت فاکتور سریع', 'acc:invoice_quick') ],
        [ kb_btn(icon('list').' لیست قراردادها', 'acc:list_contracts'),
          kb_btn(icon('list').' لیست فاکتورها', 'acc:list_invoices') ],
        [ kb_btn(icon('people').' مشتری جدید (نمونه)', 'acc:cust_demo') ],
    ];
    $text = icon('accounting') . " <b>حسابداری</b>\nیکی از گزینه‌ها را انتخاب کنید:";
    $target = $chat_id > 0 ? $chat_id : $uid;
    tg_send_kb_html($target, $text, $rows);
}

function acc_nav_rows(): array {
    return [[ kb_btn(icon('accounting').' بازگشت به حسابداری', 'acc:menu') ]];
}

function acc_handle(int $uid, string $data, int $chat_id, int $mid): void {
    vm_ack_cb_if_possible();
    $target = $chat_id > 0 ? $chat_id : $uid;

    if ($data === 'acc:menu') { acc_menu($uid, $chat_id, $mid); return; }
    if ($data === 'acc:cust_demo') {
        $c = ['id'=>0,'brand'=>'نمونه مشتری','contact'=>'09XXXXXXXXX','created_at'=>date('Y-m-d H:i:s')];
        $id = cust_save($c);
        tg_send_kb_html($target, icon('ok')." مشتری نمونه با شناسه #$id ثبت شد.", acc_nav_rows()); return;
    }
    if ($data === 'acc:contract_quick') {
        $all = cust_all(); $cid = 1;
        if (!isset($all['items']) || count($all['items'])===0) {
            $cid = cust_save(['id'=>0,'brand'=>'مشتری پیش‌فرض','contact'=>'unknown','created_at'=>date('Y-m-d H:i:s')]);
        } else { $cid = (int)$all['items'][0]['id']; }
        $id = contract_create($cid,'قرارداد خدمات پایه','5000000');
        tg_send_kb_html($target, icon('ok')." قرارداد #$id برای مشتری #$cid ثبت شد.", acc_nav_rows()); return;
    }
    if ($data === 'acc:invoice_quick') {
        $all = cust_all(); $cid = 1;
        if (!isset($all['items']) || count($all['items'])===0) {
            $cid = cust_save(['id'=>0,'brand'=>'مشتری پیش‌فرض','contact'=>'unknown','created_at'=>date('Y-m-d H:i:s')]);
        } else { $cid = (int)$all['items'][0]['id']; }
        $id = invoice_create($cid,'فاکتور خدمات پایه','5000000');
        tg_send_kb_html($target, icon('ok')." فاکتور #$id برای مشتری #$cid ثبت شد.", acc_nav_rows()); return;
    }
    if ($data === 'acc:list_contracts') {
        $all = contract_all(); $items = $all['items'] ?? []; $lines=[];
        foreach($items as $it){ $lines[]="#{$it['id']} | C{$it['customer_id']} | {$it['title']} | {$it['amount']} | {$it['status']}"; }
        $txt = icon('contract')." <b>لیست قراردادها</b>\n".(count($lines)?implode("\n",$lines):'خالی است.');
        tg_send_kb_html($target,$txt,acc_nav_rows()); return;
    }
    if ($data === 'acc:list_invoices') {
        $all = invoice_all(); $items=$all['items']??[]; $lines=[];
        foreach($items as $it){ $lines[]="#{$it['id']} | C{$it['customer_id']} | {$it['title']} | {$it['amount']} | {$it['status']}"; }
        $txt = icon('invoice')." <b>لیست فاکتورها</b>\n".(count($lines)?implode("\n",$lines):'خالی است.');
        tg_send_kb_html($target,$txt,acc_nav_rows()); return;
    }
    tg_send_kb_html($target,icon('warn')." دستور نامعتبر است.",acc_nav_rows());
}
