<?php
declare(strict_types=1);

if (!defined('STORAGE_DIR')) define('STORAGE_DIR', __DIR__ . '/../storage');

function storage_read_json(string $file) {
    if (!file_exists($file)) return [];
    $j = @file_get_contents($file);
    $d = @json_decode($j, true);
    return is_array($d) ? $d : [];
}
function storage_write_json(string $file, $data): bool {
    $j = json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
    return (bool)@file_put_contents($file, $j);
}

// settings (with defaults per your company)
function settings_all(): array {
    $f = STORAGE_DIR . '/settings.json';
    $s = storage_read_json($f);
    if (!$s) {
        $s = [
            'company'=>[
                'name'=>'البرز مدیا دوراندیش (ویژن مدیا)',
                'reg_no'=>'۴۲۵۶۳',
                'national_id'=>'۱۴۰۱۱۱۲۸۲۲۲',
                'address'=>'کرج، جهانشهر، میدان سپاه، مجتمع تجاری گلستان',
                'phones'=>['09331903872','09981381737','02634425880','02191305883'],
                'website'=>'www.visionmedia.ir',
                'logo'=>null,
                'bank'=>[
                    'card'=>'5859838820334401',
                    'account'=>'03590300021',
                    'iban'=>'IR410180000000103590300021',
                    'holder'=>'شرکت البرز مدیا دوراندیش (ویژن مدیا)'
                ]
            ],
            'welcome_enabled'=>true,
            'pdf_enabled'=>true,
            'vat_percent'=>10,
            'cron_interval_min'=>5,
            'holiday_list'=>[],
            'groups'=>[],
            'cost_categories'=>['حقوق و دستمزد','اجاره','تجهیزات/لوازم','حمل‌ونقل','تبلیغات','مالیات/کارمزد بانکی','سایر'],
            'backup_auto'=>true,
            'roles'=>[
                'ceo_ids'=>[894457439],
                'leadadmin_ids'=>[1055485720],
                'dm_ids'=>[287098219,162160538],
                'script_ids'=>[1945384893],
                'video_ids'=>[620344705],
                'blogger_ids'=>[],
                'editor_ids'=>[],
                'admin_ids'=>[],
                'accountant_ids'=>[]
            ]
        ];
        storage_write_json($f,$s);
    }
    return $s;
}
