<?php
declare(strict_types=1);

require_once __DIR__ . '/storage.php';

const RR_FILE = 'role_requests.json';

function rr_load(): array {
    $d = storage_json_get(RR_FILE);
    if (!$d) $d = ['last_id' => 0, 'items' => []];
    if (!isset($d['items'])) $d['items'] = [];
    if (!isset($d['last_id'])) $d['last_id'] = 0;
    return $d;
}

function rr_save(array $d): void {
    storage_json_put(RR_FILE, $d);
}

function rr_create(int $user_id, string $role, string $full_name = ''): int {
    $d = rr_load();
    $id = (int)$d['last_id'] + 1;
    $item = [
        'id' => $id,
        'user_id' => $user_id,
        'role' => $role,
        'full_name' => $full_name,
        'status' => 'pending',
        'created_at' => date('Y-m-d H:i:s'),
    ];
    $d['last_id'] = $id;
    $d['items'][] = $item;
    rr_save($d);
    return $id;
}

function rr_count_pending(): int {
    $d = rr_load();
    return count(array_filter($d['items'], fn($x) => ($x['status'] ?? 'pending') === 'pending'));
}
