<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../handlers/accounting.php';
function acc_bind_handle_text(int $uid,int $chat_id,string $text):bool{
    $t=trim(preg_replace('/\s+/u',' ',$text));
    if($t==='')return false;
    if(!function_exists('is_ceo')||!is_ceo($uid))return false;
    $t_norm=str_replace(['ي','ك'],['ی','ک'],$t);
    if(mb_stripos($t_norm,'حسابداری')!==false){acc_menu($uid,$chat_id,0);return true;}
    if(mb_stripos($t_norm,'فاکتور')!==false){acc_handle($uid,'acc:list_invoices',$chat_id,0);return true;}
    if(mb_stripos($t_norm,'قرارداد')!==false){acc_handle($uid,'acc:list_contracts',$chat_id,0);return true;}
    if(mb_stripos($t_norm,'مشتری')!==false&&mb_stripos($t_norm,'جدید')!==false){acc_handle($uid,'acc:cust_demo',$chat_id,0);return true;}
    return false;
}
