<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/storage.php';
require_once __DIR__ . '/../functions/state.php';

function customer_menu(int $chat_id): void {
    $rows = [
        [ kb_btn('🛍 فروشگاه','shop:menu'), kb_btn('سرویس‌های من','svc:mine') ],
        [ kb_btn('قراردادها','ctr:cust'), kb_btn('فاکتورها','inv:cust') ],
        [ kb_btn('صورتحساب من','bill:mine'), kb_btn('آفیش‌های من','off:cust') ],
        [ kb_btn('پروفایل من','profile:cust'), kb_btn('درخواست پشتیبانی','sup:new') ],
        [ kb_btn('↩️ بازگشت','home') ]
    ];
    tg_send_html($chat_id,'<b>پنل مشتری</b>', $rows);
}

function customer_handle(string $data, int $chat_id): void {
    if ($data==='cust:menu'){ customer_menu($chat_id); return; }
    if ($data==='shop:menu'){ tg_send_html($chat_id,'فروشگاه—به‌زودی',[[kb_btn('↩️ بازگشت','cust:menu')]]); return; }
    if ($data==='sup:new'){ tg_send_html($chat_id,'ثبت تیکت پشتیبانی—به‌زودی',[[kb_btn('↩️ بازگشت','cust:menu')]]); return; }
    tg_send_html($chat_id,'بخش انتخابی بزودی…',[[kb_btn('↩️ بازگشت','cust:menu')]]);
}

function onboard_customer_start(int $chat_id, int $uid): void {
    state_set($uid, ['step'=>'cust_name']);
    tg_send_html($chat_id, "👋 لطفاً <b>نام و نام‌خانوادگی</b> را ارسال کنید:");
}
function onboard_customer_handle_text(int $chat_id, int $uid, string $text): bool {
    $st = state_get($uid);
    if (!$st) return false;
    if ($st['step']==='cust_name') {
        $st['name'] = trim($text);
        $st['step'] = 'cust_mobile';
        state_set($uid,$st);
        tg_send_html($chat_id, "✅ نام ثبت شد. حالا <b>شماره موبایل</b> را ارسال کنید:");
        return true;
    }
    if ($st['step']==='cust_mobile') {
        $mobile = preg_replace('/[^0-9]+/','', $text);
        if (strlen($mobile)<10) { tg_send_html($chat_id, 'شماره معتبر نیست. دوباره بفرست.'); return true; }
        // store customer
        $file = STORAGE_DIR.'/customers.json';
        $c = storage_read_json($file);
        $items = $c['items'] ?? [];
        $id = count($items)+1;
        $items[] = ['id'=>$id, 'tg_uid'=>$uid, 'name'=>$st['name'], 'mobile'=>$mobile, 'created_at'=>vm_date_g()];
        storage_write_json($file, ['items'=>$items]);
        state_clear($uid);
        tg_send_html($chat_id, "🎉 ثبت‌نام انجام شد. حالا وارد <b>پنل مشتری</b> شدی.", [[kb_btn('ورود به پنل مشتری','cust:menu')]]);
        return true;
    }
    return false;
}
