<?php
declare(strict_types=1);
require_once __DIR__ . '/storage.php';

function state_get(int $uid): array {
    $f = STORAGE_DIR.'/state.json';
    $s = storage_read_json($f);
    return $s[(string)$uid] ?? [];
}
function state_set(int $uid, array $st): void {
    $f = STORAGE_DIR.'/state.json';
    $s = storage_read_json($f);
    $s[(string)$uid] = $st;
    storage_write_json($f,$s);
}
function state_clear(int $uid): void {
    $f = STORAGE_DIR.'/state.json';
    $s = storage_read_json($f);
    unset($s[(string)$uid]);
    storage_write_json($f,$s);
}
