<?php
declare(strict_types=1);

$cfg = require __DIR__ . '/config.php';
date_default_timezone_set($cfg['TIMEZONE'] ?? 'Asia/Tehran');

require_once __DIR__ . '/functions/utils.php';
require_once __DIR__ . '/functions/telegram.php';
require_once __DIR__ . '/functions/storage.php';
require_once __DIR__ . '/functions/state.php';

require_once __DIR__ . '/modules/ceo.php';
require_once __DIR__ . '/modules/accounting.php';
require_once __DIR__ . '/modules/dm.php';
require_once __DIR__ . '/modules/leadadmin.php';
require_once __DIR__ . '/modules/admin.php';
require_once __DIR__ . '/modules/blogger.php';
require_once __DIR__ . '/modules/videographer.php';
require_once __DIR__ . '/modules/editor.php';
require_once __DIR__ . '/modules/script.php';
require_once __DIR__ . '/modules/customer.php';

// کران ساده
if (isset($_GET['cron'])) { vm_log('Cron tick'); echo 'OK'; exit; }

$input = file_get_contents('php://input');
$u = json_decode($input ?: '{}', true);
if (!$u) { echo 'OK'; exit; }

$chat_id = $u['message']['chat']['id'] ?? ($u['callback_query']['message']['chat']['id'] ?? 0);
$text    = trim($u['message']['text'] ?? '');
$cb      = $u['callback_query']['data'] ?? null;
$cb_id   = $u['callback_query']['id'] ?? null;

$uid = $u['message']['from']['id'] ?? ($u['callback_query']['from']['id'] ?? 0);
$settings = settings_all();
$is_ceo = in_array($uid, $settings['roles']['ceo_ids'] ?? []);
$is_acc = in_array($uid, $settings['roles']['accountant_ids'] ?? []);

function friendly_greeting(): string {
    $h = (int)date('H');
    if ($h>=6 && $h<=10) return 'صبح بخیر ☀️';
    if ($h>=11 && $h<=13) return 'ظهر بخیر ☀️';
    if ($h>=14 && $h<=16) return 'بعدازظهر بخیر 🌤';
    if ($h>=17 && $h<=20) return 'عصر بخیر 🌇';
    if ($h>=21 && $h<=23) return 'شب بخیر 🌙';
    return 'بامداد بخیر 🌙';
}

function home_menu(int $chat_id, bool $is_ceo, bool $is_acc): void {
    $kb = [];
    $kb[] = [ kb_btn('من کارمند هستم','onboard:emp'), kb_btn('من مشتری هستم','onboard:cust') ];
    if ($is_ceo) $kb[] = [ kb_btn('ورود مدیرعامل','ceo:menu') ];
    if ($is_acc) $kb[] = [ kb_btn('ورود حسابداری','acc:menu') ];
    tg_send_html($chat_id, friendly_greeting().' به <b>ویژن‌مدیا</b> خوش آمدید ✨', $kb);
}

// /start
if ($text === '/start') {
    home_menu($chat_id, $is_ceo, $is_acc);
    echo 'OK'; exit;
}

// handle callback
if ($cb) {
    if ($cb==='home') { home_menu($chat_id, $is_ceo, $is_acc); echo 'OK'; exit; }
    if ($cb==='onboard:cust') { onboard_customer_start($chat_id, $uid); echo 'OK'; exit; }
    if ($cb==='onboard:emp') { tg_send_html($chat_id, 'در حال بررسی توسط حسابداری. لطفاً صبر کنید. اطلاعات تماس: www.visionmedia.ir', [[kb_btn('↩️ خانه','home')]]); echo 'OK'; exit; }

    if (strpos($cb,'ceo:')===0) { ceo_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'acc:')===0 || strpos($cb,'inv:')===0 || strpos($cb,'ctr:')===0 || strpos($cb,'ledger:')===0 || strpos($cb,'minutes:')===0 || strpos($cb,'notice:')===0) { acc_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'dm:')===0 || strpos($cb,'off:')===0 || strpos($cb,'task:')===0 || strpos($cb,'cal:')===0 || strpos($cb,'leave:')===0) { dm_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'leadadmin:')===0) { leadadmin_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'admin:')===0 || strpos($cb,'report:')===0 || strpos($cb,'profile:')===0) { admin_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'blogger:')===0 || strpos($cb,'off:my')===0) { blogger_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'video:')===0 || strpos($cb,'off:confirm')===0) { videographer_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'editor:')===0) { editor_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'script:')===0 || strpos($cb,'cust:mine')===0) { script_handle($cb, $chat_id); echo 'OK'; exit; }
    if (strpos($cb,'cust:')===0 || strpos($cb,'shop:')===0 || strpos($cb,'svc:')===0 || strpos($cb,'bill:')===0 || strpos($cb,'sup:')===0) { customer_handle($cb, $chat_id); echo 'OK'; exit; }

    tg_send_html($chat_id, 'دستور ناشناخته.', [[kb_btn('↩️ خانه','home')]]);
    echo 'OK'; exit;
}

// handle text (states)
if ($text) {
    if (onboard_customer_handle_text($chat_id, $uid, $text)) { echo 'OK'; exit; }
    tg_send_html($chat_id, 'برای ادامه یکی از گزینه‌ها را انتخاب کنید:', [[kb_btn('↩️ خانه','home')]]);
    echo 'OK'; exit;
}

echo 'OK';
