from aiogram import Bot, Dispatcher, executor, types
import logging
from bot.config import TOKEN, CEO_ID
from bot.keyboards import role_kb
from datetime import datetime

logging.basicConfig(level=logging.INFO)

bot = Bot(token=TOKEN)
dp = Dispatcher(bot)

def greeting():
    hour = datetime.now().hour
    if 5 <= hour < 12:
        return "☀️ صبح بخیر و خوش آمدید!"
    elif 12 <= hour < 15:
        return "🌤 ظهر بخیر و خوش آمدید!"
    elif 15 <= hour < 18:
        return "🌇 عصر بخیر و خوش آمدید!"
    elif 18 <= hour < 24:
        return "🌙 شب بخیر و خوش آمدید!"
    else:
        return "🌌 بامداد بخیر و خوش آمدید!"

@dp.message_handler(commands=["start"])
async def send_welcome(message: types.Message):
    text = f"{greeting()}\nبه ربات Vision Media خوش آمدید. لطفاً نقش خود را انتخاب کنید:"
    await message.answer(text, reply_markup=role_kb)

@dp.callback_query_handler(lambda c: c.data in ["employee", "customer"])
async def process_role(callback_query: types.CallbackQuery):
    role = "کارمند" if callback_query.data == "employee" else "مشتری"
    await bot.send_message(callback_query.from_user.id, f"شما نقش {role} را انتخاب کردید. اطلاعات شما برای حسابداری ارسال شد.")
    await bot.send_message(CEO_ID, f"🔔 کاربر جدید ({callback_query.from_user.full_name}) درخواست نقش {role} کرده است.")
    await callback_query.answer()

if __name__ == "__main__":
    executor.start_polling(dp, skip_updates=True)
