<?php
// VisionMedia cron - payments & tasks
date_default_timezone_set('Asia/Tehran');
$config = require __DIR__.'/config.php';
require __DIR__.'/lib/Logger.php';
require __DIR__.'/lib/Storage.php';
require __DIR__.'/lib/JDate.php';
require __DIR__.'/lib/Telegram.php';
$tg = new Telegram($config['bot_token'], 'https://api.telegram.org/bot');
function jlabel_ts($ts){ require_once __DIR__.'/lib/JDate.php'; list($jy,$jm,$jd)=JDate::toJalali((int)date('Y',$ts),(int)date('n',$ts),(int)date('j',$ts)); return sprintf('%04d/%02d/%02d - %s:%s',$jy,$jm,$jd,date('H',$ts),date('i',$ts)); }

$now = time();
$late_fee = $config['late_fee'];

// Process invoices: reminders & daily late fees
$files = glob(__DIR__.'/storage/invoices/*.json') ?: [];
foreach($files as $f){
  $inv = json_decode(file_get_contents($f), true);
  if(!$inv) continue;
  $id = $inv['id']; $due = $inv['due_at']; $remaining = $inv['remaining']; $status = $inv['status'];
  // Reminders: 1 day before
  $one_day_before = $due - 86400;
  if($remaining>0 && $now >= $one_day_before && empty($inv['remind_1d'])){
    $tg->sendMessage($config['ceo_id'], "یادآور فاکتور $id: ۱ روز تا سررسید باقیست. مانده: ".number_format($remaining)." تومان");
    $inv['remind_1d']=true;
  }
  // Day-of reminders at 10, 14, 21
  $tod = date('Y-m-d', $due);
  if($remaining>0 && date('Y-m-d',$now)===$tod){
    $hrs = [10,14,21];
    foreach($hrs as $h){
      $key = 'remind_'.$h;
      $t = strtotime($tod.' %02d:00:00'); // placeholder
    }
  }
  // Late fee daily after midnight if unpaid and past due
  if($remaining>0 && $now > $due){
    $last_day = isset($inv['last_late']) ? date('Y-m-d',$inv['last_late']) : null;
    $today = date('Y-m-d',$now);
    if($last_day !== $today){
      $inv['remaining'] += $late_fee;
      $inv['last_late'] = $now;
      $tg->sendMessage($config['ceo_id'], "جریمه تاخیر روزانه برای $id اعمال شد: +".number_format($late_fee)." تومان. مانده جدید: ".number_format($inv['remaining'])." تومان");
    }
  }
  file_put_contents($f, json_encode($inv, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}


// Offish scheduler: reminders and presence
$off_files = glob(__DIR__.'/storage/tasks/OFF*.json') ?: [];
foreach($off_files as $f){
  $o = json_decode(file_get_contents($f), true); if(!$o) continue;
  $id = $o['id']; $start = $o['start']; $status = $o['status']; $team = $o['team'];
  $t = Storage::readJson('teams/'.$team.'.json', array());
  $cam = isset($t['members']['cam']) ? $t['members']['cam'] : null;
  $blog = isset($t['members']['blog']) ? $t['members']['blog'] : null;
  // 24h reminder
  if($now >= $start-86400 && empty($o['rem_24h'])){
    if($cam) $tg->sendMessage($cam, "یادآور ۲۴ساعت مانده تا آفیش $id");
    if($blog) $tg->sendMessage($blog, "یادآور ۲۴ساعت مانده تا آفیش $id");
    $o['rem_24h']=true;
  }
  // 1h reminder
  if($now >= $start-3600 && empty($o['rem_1h'])){
    if($cam) $tg->sendMessage($cam, "⏰ ۱ ساعت تا شروع آفیش $id");
    if($blog) $tg->sendMessage($blog, "⏰ ۱ ساعت تا شروع آفیش $id");
    $o['rem_1h']=true;
  }
  // At start: presence check for cam
  if($now >= $start && empty($o['presence_sent'])){
    if($cam) $tg->sendMessage($cam, "آیا در آفیش $id حاضر هستید؟", ['inline_keyboard'=>[[['text'=>'✅ بله','callback_data'=>'cam_present_yes:'.$id],[ 'text'=>'❌ خیر','callback_data'=>'cam_present_no:'.$id]]]] );
    $o['presence_sent']=true;
  }
  // After 30 minutes: finish button
  if(isset($o['start_real']) && $now >= $o['start_real'] + 1800 && empty($o['finish_prompted']) && $status!='done'){
    if($cam) $tg->sendMessage($cam, "اگر آفیش تمام شد روی دکمه بزن:", ['inline_keyboard'=>[[['text'=>'🎬 اتمام آفیش','callback_data'=>'offish_finish:'.$id]]]] );
    $o['finish_prompted']=true;
  }
  file_put_contents($f, json_encode($o, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}


// Content tasks: reminders & penalties
$tfiles = glob(__DIR__.'/storage/tasks/*.json') ?: [];
foreach($tfiles as $f){
  $t = json_decode(file_get_contents($f), true); if(!$t) continue;
  if(isset($t['type']) && ($t['type']=='content_post' || $t['type']=='content_story')){
    $assignee = $t['assignee'] ?? null; $deadline = $t['deadline'] ?? null; $status = $t['status'] ?? 'pending';
    if(!$deadline || !$assignee) continue;
    if($status=='pending' && time() >= $deadline - 5*3600 && empty($t['rem5'])){
      $tg->sendMessage($assignee, "⏰ ۵ ساعت تا مهلت «{$t['title']}» باقیست. مهلت: ".jlabel_ts($deadline), ['inline_keyboard'=>[[['text'=>'تمام شد','callback_data'=>'task_done:'.$t['id']]]]]);
      $t['rem5']=time();
    }
    if($status=='pending' && time() >= $deadline - 3600 && empty($t['rem1'])){
      $tg->sendMessage($assignee, "⏰ ۱ ساعت تا مهلت «{$t['title']}» باقیست. مهلت: ".jlabel_ts($deadline), ['inline_keyboard'=>[[['text'=>'تمام شد','callback_data'=>'task_done:'.$t['id']]]]]);
      $t['rem1']=time();
    }
    if($status!='done' && time() > $deadline && empty($t['penalized'])){
      $amt = $config['penalties']['general'] ?? 250000;
      $tg->sendMessage($assignee, "⚠️ مهلت «{$t['title']}» تمام شد. جریمهٔ عمومی ".number_format($amt)." تومان برای شما ثبت می‌شود.");
      $tg->sendMessage($config['ceo_id'], "⚠️ جریمهٔ عمومی برای کاربر $assignee بابت «{$t['title']}» اعمال شد.");
      $t['penalized']=time();
    }
    file_put_contents($f, json_encode($t, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
  }
}


// Scenario/Camera/Editor tasks auto penalties
$tfiles2 = glob(__DIR__.'/storage/tasks/*.json') ?: [];
foreach($tfiles2 as $f){
  $t = json_decode(file_get_contents($f), true); if(!$t) continue;
  $type = $t['type'] ?? '';
  if(in_array($type, ['scenario','camera_upload','editor_check'])){
    $assignee = $t['assignee'] ?? null; $deadline = $t['deadline'] ?? null; $status = $t['status'] ?? 'pending';
    if(!$assignee || !$deadline) continue;
    // Reminder 5h/1h (if not sent)
    if($status=='pending' && time() >= $deadline - 5*3600 && empty($t['rem5'])){
      $tg->sendMessage($assignee, "⏰ ۵ ساعت تا مهلت «{$t['title']}» باقیست. مهلت: ".jlabel_ts($deadline), ['inline_keyboard'=>[[['text'=>'تمام شد','callback_data'=>'task_done:'.$t['id']]]]]);
      $t['rem5']=time();
    }
    if($status=='pending' && time() >= $deadline - 3600 && empty($t['rem1'])){
      $tg->sendMessage($assignee, "⏰ ۱ ساعت تا مهلت «{$t['title']}» باقیست. مهلت: ".jlabel_ts($deadline), ['inline_keyboard'=>[[['text'=>'تمام شد','callback_data'=>'task_done:'.$t['id']]]]]);
      $t['rem1']=time();
    }
    // Overdue penalty once
    if($status!='done' && time() > $deadline && empty($t['penalized'])){
      $amt = $config['penalties']['general'] ?? 250000;
      // Add a penalty record auto without approvals (as per spec for missed tasks)
      $pid = 'PENAUTO'.time();
      $prec = array('id'=>$pid,'emp'=>$assignee,'by'=>'system','reason'=>'عدم انجام وظیفه: '.$t['title'],'amount'=>$amt,'time'=>time(),'status'=>'approved');
      file_put_contents(__DIR__.'/storage/penalties/'.$pid.'.json', json_encode($prec, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
      // Deduct immediately
      $led = file_exists(__DIR__.'/storage/payroll/'.$assignee.'.json') ? json_decode(file_get_contents(__DIR__.'/storage/payroll/'.$assignee.'.json'), true) : array('employee_id'=>$assignee,'deductions'=>array());
      $led['deductions'][] = array('id'=>$pid,'amount'=>$amt,'reason'=>$prec['reason'],'time'=>time());
      file_put_contents(__DIR__.'/storage/payroll/'.$assignee.'.json', json_encode($led, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
      // Notify
      $tg->sendMessage($assignee, "⚠️ به دلیل عدم انجام «{$t['title']}» تا موعد مقرر، جریمهٔ عمومی ".number_format($amt)." تومان برای شما ثبت و از حقوقتان کسر شد.");
      $tg->sendMessage($config['ceo_id'], "⚠️ جریمهٔ خودکار برای کاربر $assignee بابت «{$t['title']}» ثبت و کسر شد.");
      $t['penalized']=time();
    }
    file_put_contents($f, json_encode($t, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
  }
}

echo "OK\n";
