<?php
// lib/JDate.php fixed
class JDate {
  public static function div($a,$b){ return (int)($a/$b); }
  public static function toJalali($gy,$gm,$gd){
    $g_d_m = [0,31,59,90,120,151,181,212,243,273,304,334];
    $gy2 = $gy-1600; $gm2 = $gm-1; $gd2 = $gd-1;
    $g_day_no = 365*$gy2 + self::div($gy2+3,4) - self::div($gy2+99,100) + self::div($gy2+399,400);
    $g_day_no += $gd2 + $g_d_m[$gm2];
    if ($gm2>1 && (($gy%4==0 && $gy%100!=0) || ($gy%400==0))) $g_day_no++;
    $j_day_no = $g_day_no - 79;
    $j_np = self::div($j_day_no, 12053);
    $j_day_no %= 12053;
    $jy = 979 + 33*$j_np + 4*self::div($j_day_no,1461);
    $j_day_no %= 1461;
    if ($j_day_no >= 366){
      $jy += self::div($j_day_no-366,365);
      $j_day_no = ($j_day_no-366)%365;
    }
    $jm = ($j_day_no<186)? 1+self::div($j_day_no,31) : 7+self::div($j_day_no-186,30);
    $jd = 1 + (($j_day_no<186)? ($j_day_no%31) : (($j_day_no-186)%30));
    return [$jy,$jm,$jd];
  }
  public static function nowFa(){
    $t=time(); $gy=(int)date('Y',$t); $gm=(int)date('n',$t); $gd=(int)date('j',$t);
    list($jy,$jm,$jd)=self::toJalali($gy,$gm,$gd);
    return sprintf('%04d/%02d/%02d - %s:%s',$jy,$jm,$jd,date('H',$t),date('i',$t));
  }
  public static function greet(){
    $h=(int)date('G');
    if($h>=5 && $h<12) return 'صبح بخیر ☀️';
    if($h>=12 && $h<17) return 'عصر بخیر 🌤';
    if($h>=17 && $h<22) return 'شب بخیر 🌙';
    return 'بامداد بخیر 🌌';
  }
}
