<?php
/* ====== CONFIG ====== */
$botToken = "8402430685:AAFKiATwKDdwky0-KyLpK-31dmJrGD6a8zk";
$adminId  = 894457439;

/* ====== DB ====== */
$dbHost = "localhost";
$dbName = "visionme_visionmediavip1";
$dbUser = "visionme_visionmediavip2";
$dbPass = "16691669.Ir";

try{
  $pdo=new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4",$dbUser,$dbPass,[
    PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC
  ]);
}catch(Exception $e){ file_put_contents('error_log.txt',"DB: ".$e->getMessage()."\n",FILE_APPEND); exit; }

/* ====== SCHEMA AUTO ====== */
try{
  $pdo->exec("
  CREATE TABLE IF NOT EXISTS users(
    id INT AUTO_INCREMENT PRIMARY KEY,
    tg_id BIGINT UNIQUE,
    name VARCHAR(100), phone VARCHAR(32),
    role VARCHAR(50),
    status ENUM('pending','approved','customer') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS roles(
    id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(50), fa_name VARCHAR(100)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS bot_states(
    tg_id BIGINT PRIMARY KEY, state VARCHAR(50), data TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS invoices(
    id INT AUTO_INCREMENT PRIMARY KEY, user_tg BIGINT, created_by BIGINT,
    amount BIGINT, status ENUM('unpaid','paid','canceled') DEFAULT 'unpaid',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS payments(
    id INT AUTO_INCREMENT PRIMARY KEY, invoice_id INT, amount BIGINT, paid_by BIGINT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (invoice_id) REFERENCES invoices(id) ON DELETE CASCADE
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS products(
    id INT AUTO_INCREMENT PRIMARY KEY, title VARCHAR(150), price BIGINT,
    active TINYINT(1) DEFAULT 1, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS orders(
    id INT AUTO_INCREMENT PRIMARY KEY, user_tg BIGINT, total BIGINT,
    status ENUM('new','processing','done','canceled') DEFAULT 'new',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS order_items(
    id INT AUTO_INCREMENT PRIMARY KEY, order_id INT, product_id INT, qty INT, price BIGINT,
    FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS projects(
    id INT AUTO_INCREMENT PRIMARY KEY, title VARCHAR(150), description TEXT,
    manager_tg BIGINT,
    status ENUM('open','in_progress','done','canceled') DEFAULT 'open',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS tasks(
    id INT AUTO_INCREMENT PRIMARY KEY, project_id INT, title VARCHAR(200),
    assignee_tg BIGINT,
    status ENUM('todo','doing','done','canceled') DEFAULT 'todo',
    due_date DATE NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (project_id) REFERENCES projects(id) ON DELETE CASCADE
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  /* 🔔 یادآورها */
  CREATE TABLE IF NOT EXISTS reminders(
    id INT AUTO_INCREMENT PRIMARY KEY,
    target_tg BIGINT NOT NULL,
    created_by BIGINT NOT NULL,
    body TEXT NOT NULL,
    run_at DATETIME NOT NULL,
    sent TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX (run_at), INDEX (sent), INDEX (target_tg)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
  ");

  // Seed roles/products once
  $cnt=$pdo->query("SELECT COUNT(*) c FROM roles")->fetch()['c']??0;
  if(!$cnt){
    $pdo->exec("INSERT INTO roles(name,fa_name) VALUES
      ('CEO','👑 مدیرعامل'),('Accountant','💰 حسابدار'),('DepartmentManager','🧩 مدیر دپارتمان'),
      ('SeniorAdmin','⚙️ ادمین ارشد'),('Admin','🛠 ادمین'),('Customer','🧍 مشتری'),
      ('Blogger','📝 بلاگر'),('Editor','🎞 تدوینگر'),('ScriptWriter','📜 سناریونویس'),('Photographer','📷 تصویربردار')");
  }
  $pc=$pdo->query("SELECT COUNT(*) c FROM products")->fetch()['c']??0;
  if(!$pc){
    $pdo->exec("INSERT INTO products(title,price) VALUES
      ('پکیج تولید محتوای پایه',1500000),('پکیج تدوین ویدیو',2500000),('عکاسی صنعتی (هر ساعت)',900000)");
  }
}catch(Exception $e){ file_put_contents('error_log.txt',"SCHEMA: ".$e->getMessage()."\n",FILE_APPEND); }
?>
