<?php
declare(strict_types=1);

ini_set('display_errors','1'); 
ini_set('display_startup_errors','1'); 
error_reporting(E_ALL);

function ok($msg){ echo "<pre style='font:14px/1.6 monospace'>✅ $msg</pre>"; }
function bad($msg){ echo "<pre style='font:14px/1.6 monospace;color:#c00'>⛔️ $msg</pre>"; }

$step = isset($_GET['s']) ? (int)$_GET['s'] : 0;
$files = [
  'config/env.php',
  'core/bootstrap.php',
  'core/utils.php',
  'core/storage.php',
  'core/telegram.php',
  'core/scheduler.php',
  'modules/auth.php',
  'modules/tasks.php',
  'modules/accounting.php',
  'modules/department.php',
  'modules/penalties.php',
  'handlers/start.php',
  'handlers/employee.php',
  'handlers/customer.php',
  'handlers/ceo.php',
  'handlers/manager.php',
];

$total = count($files);

echo "<h3>Include step ".($step+1)." / {$total}</h3>";

for ($i=0; $i<=$step; $i++){
    if (!isset($files[$i])) {
        bad("no more files (index {$i})");
        break;
    }
    $path = __DIR__ . '/' . $files[$i];
    if (!is_file($path)) { bad("missing: {$files[$i]}"); break; }
    require_once $path;
    ok("loaded: {$files[$i]}");
}

if ($step+1 < $total) {
    echo "<p>برای مرحله بعدی: <a href='?s=".($step+1)."'>?s=".($step+1)."</a></p>";
} else {
    echo "<p>✅ همه فایل‌های تعریف‌شده بررسی شدند.</p>";
}
