<?php
declare(strict_types=1);

require_once __DIR__ . '/utils.php';
require_once __DIR__ . '/storage.php';
require_once __DIR__ . '/telegram.php';
require_once __DIR__ . '/../config/env.php';

if (!defined('QUEUE_FILE')) define('QUEUE_FILE', VM_STORAGE . '/queue.json');

function sched_queue_load(): array { return storage_load(QUEUE_FILE, []); }
function sched_queue_save(array $q): bool {
    usort($q, fn($a,$b)=>((int)($a['run_at_ts']??0))<=>((int)($b['run_at_ts']??0)));
    return storage_save(QUEUE_FILE, $q);
}
function sched_enqueue(string $type, int $run_at_ts, array $payload=[]): int {
    $q = sched_queue_load();
    $id = (count($q)? max(array_map(fn($x)=>(int)($x['id']??0),$q)) : 0) + 1;
    $q[] = ['id'=>$id,'type'=>$type,'run_at_ts'=>$run_at_ts,'payload'=>$payload,'created_ts'=>time()];
    sched_queue_save($q); return $id;
}

function sched_run(): void {
    $now = time();
    $q = sched_queue_load(); if(!$q) return;
    $remain=[];
    foreach ($q as $job) {
        if ((int)$job['run_at_ts'] > $now) { $remain[]=$job; continue; }
        $type = $job['type'] ?? '';
        $payload = $job['payload'] ?? [];
        try {
            if ($type==='send_reminder') { sched_do_send_reminder($payload); }
            elseif ($type==='delete_message') { sched_do_delete_message($payload); }
        } catch (Throwable $e) { vm_log('SCHED', 'Job error '.$type.' '.$e->getMessage()); }
    }
    sched_queue_save($remain);
}

function sched_do_send_reminder(array $payload): void {
    $chat_id=(int)($payload['chat_id']??0); if(!$chat_id) return;
    $text=$payload['text'] ?? '⏰ یادآوری';
    $kb=$payload['buttons']??null;
    if ($kb) tg_send_kb_html($chat_id,$text,$kb); else tg_send_html($chat_id,$text);
}
function sched_do_delete_message(array $payload): void {
    if (!function_exists('tg_delete_message')) return;
    $chat_id=(int)($payload['chat_id']??0); $mid=(int)($payload['message_id']??0);
    if($chat_id && $mid) tg_delete_message($chat_id,$mid);
}

/** برنامه‌ریزهای کاربردی — امضاها اینجاست تا سایر ماژول‌ها صدا بزنند **/
function sched_plan_task_reminders(): void { /* برنامه‌ریزی در modules/tasks.php هنگام ساخت انجام می‌شود */ }
function sched_plan_task_overdue_penalties(): void { /* نسخه ساده */ }
