<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/users.php';
require_once __DIR__ . '/../functions/storage.php';
require_once __DIR__ . '/../functions/reports.php';
require_once __DIR__ . '/../functions/settings.php';
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/users.php';
require_once __DIR__ . '/../functions/storage.php';
require_once __DIR__ . '/../functions/reports.php';
require_once __DIR__ . '/../functions/settings.php';

if (!function_exists('ceo_menu')) {
function ceo_menu(int $chat_id): void {
    $g = function_exists('friendly_greeting_v2') ? friendly_greeting_v2() : "سلام";
    $rows = [
        [ kb_btn("📊 داشبورد","ceo:dash"), kb_btn("⚙️ تنظیمات","ceo:settings") ],
        [ kb_btn("🧩 ماژول‌ها","ceo:features"), kb_btn("📜 لاگ‌ها","ceo:logs") ],
        [ kb_btn("🗂 پشتیبان‌گیری","ceo:backup"), kb_btn("🌐 وبهوک","ceo:webhook") ],
        [ kb_btn("👤 پرسنل","ceo:employees"), kb_btn("👥 مشتریان","ceo:customers") ],
        [ kb_btn("💰 مالی/فاکتورها","ceo:finance"), kb_btn("📑 قراردادها","ceo:contracts") ],
        [ kb_btn("🛍️ فروشگاه","ceo:store"), kb_btn("🚨 جریمه‌ها","ceo:penalties") ],
        [ kb_btn("👷‍♂️ پنل مدیر دپارتمان","ceo:open_dm") ],
        [ kb_btn("🎬 آفیش‌ها","ceo:offish"), kb_btn("🗒️ وظایف","ceo:tasks") ],
        [ kb_btn("↩️ خانه","back:home") ]
    ];
    tg_send_html($chat_id, $g." <b>پنل مدیرعامل</b>", $rows);
}}

if (!function_exists('ceo_dash')) {
function ceo_dash(int $chat_id): void {
    $users = function_exists('users_all') ? users_all() : [];
    $cust  = storage_read_json(STORAGE_DIR.'/customers.json'); $cN = is_array($cust)? (isset($cust['items'])?count($cust['items']):count($cust)) : 0;
    $contr = storage_read_json(STORAGE_DIR.'/contracts.json'); $ctN= is_array($contr)? (isset($contr['items'])?count($contr['items']):count($contr)) : 0;
    $invs  = storage_read_json(STORAGE_DIR.'/invoices.json');  $iN = is_array($invs)?  (isset($invs['items'])?count($invs['items']):count($invs))  : 0;
    $pens  = storage_read_json(STORAGE_DIR.'/penalties.json'); $pN = is_array($pens)?  (isset($pens['items'])?count($pens['items']):count($pens))  : 0;
    $tasks = storage_read_json(STORAGE_DIR.'/tasks.json');     $tN = is_array($tasks)? (isset($tasks['items'])?count($tasks['items']):count($tasks)) : 0;
    $off   = storage_read_json(STORAGE_DIR.'/offish.json');    $oN = is_array($off)?   (isset($off['items'])?count($off['items']):count($off))   : 0;
    $txt = "<b>نمای کلی</b>\n".
           "👤 پرسنل: <b>".count($users)."</b>\n".
           "👥 مشتریان: <b>".$cN."</b>\n".
           "📑 قراردادها: <b>".$ctN."</b>\n".
           "🧾 فاکتورها: <b>".$iN."</b>\n".
           "🚨 جریمه‌ها: <b>".$pN."</b>\n".
           "🗒️ وظایف: <b>".$tN."</b>\n".
           "🎬 آفیش‌ها: <b>".$oN."</b>";
    tg_send_html($chat_id, $txt, [[kb_btn("↩️ بازگشت","ceo:menu")]]);
}}

if (!function_exists('ceo_employees')) {
function ceo_employees(int $chat_id): void {
    $list = function_exists('users_all') ? users_all() : [];
    if (!$list) { tg_send_html($chat_id, "پرسنلی ثبت نشده.", [[kb_btn("↩️ بازگشت","ceo:menu")]]); return; }
    $kb = [];
    foreach ($list as $u) {
        $label = ($u['first_name'] ?? 'بدون‌نام')." — ".($u['role'] ?? '-');
        $kb[] = [ kb_btn($label, "ceo:report:".(int)($u['id'] ?? 0)) ];
    }
    $kb[] = [ kb_btn("↩️ بازگشت","ceo:menu") ];
    tg_send_html($chat_id, "<b>پرسنل</b> — برای گزارش فردی کلیک کنید:", $kb);
}}

if (!function_exists('ceo_customers')) {
function ceo_customers(int $chat_id): void {
    $cust = storage_read_json(STORAGE_DIR.'/customers.json');
    $items = is_array($cust) ? ($cust['items'] ?? $cust) : [];
    if (!$items) { tg_send_html($chat_id, "مشتری ثبت نشده.", [[kb_btn("↩️ بازگشت","ceo:menu")]]); return; }
    $kb = []; $i=1;
    foreach ($items as $c) {
        $name = ($c['name'] ?? $c['customer_name'] ?? 'مشتری #'.$i);
        $kb[] = [ kb_btn("#".$i." — ".$name, "noop") ];
        $i++;
    }
    $kb[] = [ kb_btn("باز کردن در حسابداری","acc:customers") ];
    $kb[] = [ kb_btn("↩️ بازگشت","ceo:menu") ];
    tg_send_html($chat_id, "<b>لیست مشتریان</b>", $kb);
}}

if (!function_exists('ceo_finance')) {
function ceo_finance(int $chat_id): void {
    $inv = storage_read_json(STORAGE_DIR.'/invoices.json');
    $items = is_array($inv) ? ($inv['items'] ?? $inv) : [];
    $sum = 0; $cnt = 0;
    foreach ($items as $v) { $sum += (int)($v['amount'] ?? 0); $cnt++; }
    $txt = "<b>امور مالی</b>\nتعداد فاکتورها: <b>".$cnt."</b>\nجمع مبالغ: <b>".number_format($sum)." تومان</b>";
    $kb = [
        [ kb_btn("مشاهدهٔ فاکتورها", "acc:invoices"), kb_btn("لیست قراردادها", "acc:contracts") ],
        [ kb_btn("↩️ بازگشت","ceo:menu") ]
    ];
    tg_send_html($chat_id, $txt, $kb);
}}

if (!function_exists('ceo_contracts')) {
function ceo_contracts(int $chat_id): void {
    $contr = storage_read_json(STORAGE_DIR.'/contracts.json');
    $items = is_array($contr) ? ($contr['items'] ?? $contr) : [];
    if (!$items) { tg_send_html($chat_id, "قراردادی ثبت نشده.", [[kb_btn("↩️ بازگشت","ceo:menu")]]); return; }
    $kb = []; $i=1;
    foreach ($items as $c) {
        $name = ($c['customer_name'] ?? 'بدون‌نام');
        $svc = ($c['service'] ?? '-');
        $kb[] = [ kb_btn("#".$i." — ".$name." — ".$svc, "noop") ];
        $i++;
    }
    $kb[] = [ kb_btn("↩️ بازگشت","ceo:menu") ];
    tg_send_html($chat_id, "<b>قراردادها</b>", $kb);
}}

if (!function_exists('ceo_store')) {
function ceo_store(int $chat_id): void {
    $store = storage_read_json(STORAGE_DIR.'/store.json');
    $items = is_array($store) ? ($store['items'] ?? $store) : [];
    if (!$items) { tg_send_html($chat_id, "خدمتی ثبت نشده.", [[kb_btn("افزودن خدمت ➕","acc:store:add")],[kb_btn("↩️ بازگشت","ceo:menu")]]); return; }
    $kb = []; $i=1;
    foreach ($items as $s) {
        $ttl = ($s['title'] ?? 'خدمت #'.$i);
        $prc = number_format((int)($s['price'] ?? 0))." تومان";
        $id  = (int)($s['id'] ?? $i);
        $kb[] = [ kb_btn($ttl." — ".$prc, "acc:store:item:".$id) ];
        $i++;
    }
    $kb[] = [ kb_btn("↩️ بازگشت","ceo:menu") ];
    tg_send_html($chat_id, "<b>فروشگاه</b>", $kb);
}}

if (!function_exists('ceo_penalties')) {
function ceo_penalties(int $chat_id): void {
    $pens = storage_read_json(STORAGE_DIR.'/penalties.json');
    $items = is_array($pens) ? ($pens['items'] ?? $pens) : [];
    if (!$items) { tg_send_html($chat_id, "فعلاً جریمه‌ای وجود ندارد.", [[kb_btn("↩️ بازگشت","ceo:menu")]]); return; }
    $kb = []; $i=1;
    foreach ($items as $p) {
        $emp = ($p['employee_name'] ?? ('#'.($p['employee_id'] ?? 0)));
        $amt = number_format((int)($p['amount'] ?? 0));
        $st = ($p['status'] ?? 'در انتظار');
        $kb[] = [ kb_btn("#".$i." — ".$emp." — ".$amt." — ".$st, "noop") ];
        $i++;
    }
    $kb[] = [ kb_btn("↩️ بازگشت","ceo:menu") ];
    tg_send_html($chat_id, "<b>جریمه‌ها</b>", $kb);
}}

if (!function_exists('ceo_offish')) {
function ceo_offish(int $chat_id): void {
    $off = storage_read_json(STORAGE_DIR.'/offish.json');
    $items = is_array($off) ? ($off['items'] ?? $off) : [];
    if (!$items) { tg_send_html($chat_id, "آفیشی ثبت نشده.", [[kb_btn("↩️ بازگشت","ceo:menu")]]); return; }
    $kb = []; $i=1;
    foreach ($items as $o) {
        $cust = ($o['customer_name'] ?? '-');
        $dt = ($o['date'] ?? ($o['start_at'] ?? ''));
        $kb[] = [ kb_btn("#".$i." — ".$cust." — ".$dt, "noop") ];
        $i++;
    }
    $kb[] = [ kb_btn("↩️ بازگشت","ceo:menu") ];
    tg_send_html($chat_id, "<b>آفیش‌ها</b>", $kb);
}}

if (!function_exists('ceo_tasks')) {
function ceo_tasks(int $chat_id): void {
    $tasks = storage_read_json(STORAGE_DIR.'/tasks.json');
    $items = is_array($tasks) ? ($tasks['items'] ?? $tasks) : [];
    if (!$items) { tg_send_html($chat_id, "وظیفه‌ای ثبت نشده.", [[kb_btn("↩️ بازگشت","ceo:menu")]]); return; }
    $kb = []; $i=1;
    foreach ($items as $t) {
        $ttl = ($t['title'] ?? 'بدون‌عنوان');
        $asg = (string)($t['assignee_name'] ?? ('#'.($t['assignee_id'] ?? 0)));
        $kb[] = [ kb_btn("#".$i." — ".$ttl." — ".$asg, "noop") ];
        $i++;
    }
    $kb[] = [ kb_btn("↩️ بازگشت","ceo:menu") ];
    tg_send_html($chat_id, "<b>وظایف</b>", $kb);
}}

if (!function_exists('ceo_settings_menu')) {
function ceo_settings_menu(int $chat_id): void {
    $cfg = settings_all();
    $txt = "<b>تنظیمات ربات</b>\n".
           "جریمه دیرکرد: <b>".number_format((int)$cfg['late_fee_per_day'])." تومان</b>\n".
           "سهمیه آفیش: <b>".$cfg['offish_quota_per_month']."</b>\n".
           "AutoReports: <b>".($cfg['auto_reports_enabled']?'ON':'OFF')."</b>\n".
           "Deadline ساعت: <b>".$cfg['workday_end_hour']."</b>";
    $kb = [
        [ kb_btn("↩️ بازگشت","ceo:menu") ]
    ];
    tg_send_html($chat_id, $txt, $kb);
}}
if (!function_exists('ceo_features_menu')) {
function ceo_features_menu(int $chat_id): void {
    $cfg = settings_all();
    $txt = "<b>ماژول‌ها</b>\nAutoReports: <b>".($cfg['auto_reports_enabled']?'ON':'OFF')."</b>";
    tg_send_html($chat_id, $txt, [[kb_btn("↩️ بازگشت","ceo:menu")]]);
}}
if (!function_exists('ceo_logs_menu')) {
function ceo_logs_menu(int $chat_id): void {
    $log = __DIR__ . '/../logs/bot.log';
    if (!file_exists($log)) { tg_send_html($chat_id, "فعلاً لاگی موجود نیست.", [[kb_btn("↩️ بازگشت","ceo:menu")]]); return; }
    $lines = @file($log); $tail = array_slice($lines ?: [], -20);
    $txt = "<b>آخرین رویدادها</b>\n".htmlspecialchars(implode("", $tail), ENT_QUOTES|ENT_SUBSTITUTE,"UTF-8");
    tg_send_html($chat_id, $txt, [[kb_btn("↩️ بازگشت","ceo:menu")]]);
}}
if (!function_exists('ceo_backup_now')) {
function ceo_backup_now(int $chat_id): void {
    $out = STORAGE_DIR . '/backup-'.date('Ymd-His').'.json';
    @file_put_contents($out, json_encode(['ok'=>true,'t'=>time()], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
    tg_send_html($chat_id, "بکاپ انجام شد: <code>".basename($out)."</code>", [[kb_btn("↩️ بازگشت","ceo:menu")]]);
}}
if (!function_exists('ceo_webhook_menu')) {
function ceo_webhook_menu(int $chat_id): void {
    $cfg = function_exists('vm_config_load') ? vm_config_load() : [];
    $base = $cfg['BASE_URL'] ?? '';
    $kb = [
        [ kb_btn("SetWebhook","ceo:webhook:set"), kb_btn("DeleteWebhook","ceo:webhook:del") ],
        [ kb_btn("↩️ بازگشت","ceo:menu") ]
    ];
    tg_send_html($chat_id, "<b>وبهوک</b>\nBASE_URL: <code>".$base."</code>", $kb);
}}

if (!function_exists('ceo_handle')) {
function ceo_handle(string $data, int $chat_id): void {
    if ($data==='ceo:open_dm') { try { if (!function_exists('dm_menu')) { @include_once __DIR__ . '/dm.php'; } if (function_exists('dm_menu')) { dm_menu($chat_id); } else { tg_send_html($chat_id,'پنل مدیر دپارتمان نصب نیست.'); } } catch (Throwable $e) { if (function_exists('vm_log')) vm_log('CEO ceo:open_dm ERR: '.$e->getMessage()); tg_send_html($chat_id,'⛔️ خطای داخلی (DM).'); } return; }
if ($data==='noop') { tg_send_html($chat_id,'ℹ️ نمایش آیتم.'); return; }
    if ($data==='back:home') { ceo_menu($chat_id); return; }
    if ($data==='ceo:menu') { ceo_menu($chat_id); return; }
    if ($data==='ceo:dash') { ceo_dash($chat_id); return; }
    if ($data==='ceo:employees') { ceo_employees($chat_id); return; }
    if ($data==='ceo:customers') { ceo_customers($chat_id); return; }
    if ($data==='ceo:finance') { ceo_finance($chat_id); return; }
    if ($data==='ceo:contracts') { ceo_contracts($chat_id); return; }
    if ($data==='ceo:store') { ceo_store($chat_id); return; }
    if ($data==='ceo:penalties') { ceo_penalties($chat_id); return; }
    if ($data==='ceo:offish') { ceo_offish($chat_id); return; }
    if ($data==='ceo:tasks') { ceo_tasks($chat_id); return; }
    if ($data==='ceo:settings') { ceo_settings_menu($chat_id); return; }
    if ($data==='ceo:features') { ceo_features_menu($chat_id); return; }
    if ($data==='ceo:logs') { ceo_logs_menu($chat_id); return; }
    if ($data==='ceo:backup') { ceo_backup_now($chat_id); return; }
    if ($data==='ceo:webhook') { ceo_webhook_menu($chat_id); return; }
    if ($data==='ceo:webhook:set') { tg_api('setWebhook', ['url'=>(function_exists('vm_config_load')?(vm_config_load()['BASE_URL']??''):'')]); tg_send_html($chat_id,'SetWebhook ارسال شد.', [[kb_btn("↩️ بازگشت","ceo:webhook")]]); return; }
    if ($data==='ceo:webhook:del') { tg_api('deleteWebhook', []); tg_send_html($chat_id,'Webhook حذف شد.', [[kb_btn("↩️ بازگشت","ceo:webhook")]]); return; }

    if ($data==='ceo:reports') {
        $u = function_exists('users_all') ? users_all() : [];
        $kb = [];
        foreach ($u as $x) {
            $kb[] = [ kb_btn(($x['first_name'] ?? 'بدون‌نام')." — ".($x['role'] ?? '-'), "ceo:report:".(int)($x['id'] ?? 0)) ];
        }
        if (!$kb) $kb = [[kb_btn("موردی نیست","ceo:menu")]];
        tg_send_html($chat_id, "<b>یک نفر را انتخاب کنید</b>", $kb);
        return;
    }
    if (strpos($data,'ceo:report:')===0) {
        $id = (int)substr($data, strlen('ceo:report:'));
        $kb = [
            [ kb_btn("امروز", "ceo:reportp:day:".$id), kb_btn("این هفته", "ceo:reportp:week:".$id), kb_btn("این ماه", "ceo:reportp:month:".$id) ],
            [ kb_btn("↩️ بازگشت", "ceo:reports") ]
        ];
        tg_send_html($chat_id, "بازهٔ گزارش را انتخاب کنید:", $kb);
        return;
    }
    if (strpos($data,'ceo:reportp:')===0) {
        $parts = explode(':', $data);
        $period = $parts[2] ?? 'week';
        $id = (int)($parts[3] ?? 0);
        if (function_exists('vm_report_employee_text')) {
            $txt = vm_report_employee_text($id, $period);
            tg_send_html($chat_id, $txt, [[kb_btn("↩️ بازگشت","ceo:report:".$id)]]);
        } else {
            tg_send_html($chat_id, "ماژول گزارش دردسترس نیست.", [[kb_btn("↩️ بازگشت","ceo:reports")]]);
        }
        return;
    }
    tg_send_html($chat_id, "دستور ناشناخته در پنل مدیرعامل.");
}}

if (!function_exists('storage_read_json')) {
    if (!defined('STORAGE_DIR')) { define('STORAGE_DIR', __DIR__ . '/../storage'); }
    function storage_read_json(string $file) {
        if (!file_exists($file)) return [];
        $j = @file_get_contents($file);
        $d = @json_decode($j, true);
        return is_array($d) ? $d : [];
    }
}

if (!function_exists('kb_btn')) {
function kb_btn(string $title, string $data): array { return ['text'=>$title, 'callback_data'=>$data]; }
}
