<?php
/**
 * Hotfix v89 – CEO autopanel:
 * - /ceo now prefers ceo_plus_menu (richer UI)
 * - /start auto-opens CEO panel if user id in owners.json
 */
@ini_set('display_errors','0');
@ini_set('log_errors','1');
date_default_timezone_set('Asia/Tehran');

$BASE = __DIR__;
function _owners(){ $f=__DIR__.'/storage/owners.json'; if(!is_file($f)) return ['ceo_ids'=>[]]; $j=@file_get_contents($f); $d=@json_decode($j,true); return is_array($d)?$d:['ceo_ids'=>[]]; }

$raw=@file_get_contents('php://input');
$upd=@json_decode($raw,true);
if(!$upd){ http_response_code(200); echo 'OK'; exit; }

// we only override start/ceo paths and then exit; for other routes, let main index handle it.
if(isset($upd['message'])){
  $msg=$upd['message']; $chat_id=(int)($msg['chat']['id']??0); $text=trim((string)($msg['text']??''));
  if ($text==='/start'){
    $o=_owners();
    if (in_array($chat_id, $o['ceo_ids']??[], true)){
      if (function_exists('ceo_plus_menu')){ ceo_plus_menu($chat_id,$msg['from']??[]); http_response_code(200); echo 'OK'; exit; }
      if (function_exists('ceo_menu')){ ceo_menu($chat_id,$msg['from']??[]); http_response_code(200); echo 'OK'; exit; }
    }
  }
  if ($text==='/ceo'){
    if (function_exists('ceo_plus_menu')){ ceo_plus_menu($chat_id,$msg['from']??[]); http_response_code(200); echo 'OK'; exit; }
    if (function_exists('ceo_menu')){ ceo_menu($chat_id,$msg['from']??[]); http_response_code(200); echo 'OK'; exit; }
  }
}
if(isset($upd['callback_query'])){
  $cb=$upd['callback_query']; $data=(string)($cb['data']??''); $chat_id=(int)($cb['message']['chat']['id']??0);
  if ($data==='ceo:menu'){
    if (function_exists('ceo_plus_menu')){ ceo_plus_menu($chat_id,$cb['from']??[]); http_response_code(200); echo 'OK'; exit; }
  }
}

// if not matched, fall through so main index.php continues
http_response_code(418); // signal to main index to continue (ignored by Telegram)
?>