<?php
declare(strict_types=1);

// ⇦ اگر قبلاً خطاهای 500 داشتی، این 3 خط دیباگ مفیدند. می‌تونی بعد از راه افتادن خاموش‌شون کنی.
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require_once __DIR__ . '/../config/env.php';

// منطقه زمانی و پوشه‌ها
@date_default_timezone_set('Asia/Tehran');
if (!is_dir(__DIR__ . '/../storage')) @mkdir(__DIR__ . '/../storage', 0775, true);
if (!is_dir(__DIR__ . '/../storage/logs')) @mkdir(__DIR__ . '/../storage/logs', 0775, true);

// لاگر ساده
if (!function_exists('vm_log')) {
    function vm_log(string $ch, string $msg): void {
        $line = sprintf("[%s] [%s] %s\n", date('d-M-Y H:i:s T'), $ch, $msg);
        @file_put_contents(__DIR__ . '/../storage/logs/app.log', $line, FILE_APPEND);
    }
}

vm_log('BOOT', 'Bootstrap initialized.');
vm_log('BOOT', 'Bootstrap ready (timezone=Asia/Tehran, jalali=on).');

// هسته‌ها
require_once __DIR__ . '/utils.php';
require_once __DIR__ . '/storage.php';
require_once __DIR__ . '/telegram.php';
require_once __DIR__ . '/scheduler.php';
