<?php
declare(strict_types=1);

require_once __DIR__ . '/../config/env.php';

function storage_load(string $file, $default = []) {
    if (!is_file($file)) return $default;
    $raw = @file_get_contents($file);
    $j = json_decode($raw ?: 'null', true);
    return is_array($j) ? $j : $default;
}
function storage_save(string $file, $data): bool {
    if (!is_dir(dirname($file))) @mkdir(dirname($file), 0775, true);
    return (bool)@file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}

if (!defined('USERS_FILE'))      define('USERS_FILE',      VM_STORAGE.'/users.json');
if (!defined('EMPLOYEES_FILE'))  define('EMPLOYEES_FILE',  VM_STORAGE.'/employees.json');
if (!defined('CUSTOMERS_FILE'))  define('CUSTOMERS_FILE',  VM_STORAGE.'/customers.json');
if (!defined('SERVICES_FILE'))   define('SERVICES_FILE',   VM_STORAGE.'/services.json');
if (!defined('INVC_FILE'))       define('INVC_FILE',       VM_STORAGE.'/invoices.json');
if (!defined('TASKS_FILE'))      define('TASKS_FILE',      VM_STORAGE.'/tasks.json');
if (!defined('PENAL_FILE'))      define('PENAL_FILE',      VM_STORAGE.'/penalties.json');
if (!defined('SHOOTS_FILE'))     define('SHOOTS_FILE',     VM_STORAGE.'/shoots.json');
if (!defined('SCENARIOS_FILE'))  define('SCENARIOS_FILE',  VM_STORAGE.'/scenarios.json');
if (!defined('EDITS_FILE'))      define('EDITS_FILE',      VM_STORAGE.'/edits.json');
if (!defined('QUEUE_FILE'))      define('QUEUE_FILE',      VM_STORAGE.'/queue.json');
