<?php
declare(strict_types=1);

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/storage.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../config/env.php';
require_once __DIR__ . '/../handlers/employee.php';
require_once __DIR__ . '/../handlers/customer.php';
require_once __DIR__ . '/../handlers/manager.php';
require_once __DIR__ . '/../handlers/ceo.php';
require_once __DIR__ . '/../modules/accounting.php';
require_once __DIR__ . '/../modules/department.php';

/** بازکردن پنل مناسب برای یک کاربر */
if (!function_exists('open_user_panel')) {
    function open_user_panel(int $user_id): void {
        if ($user_id === CEO_UID) { ceo_menu_main($user_id); return; }

        // اگر در customers.json باشد → پنل مشتری
        $custs = storage_load(CUSTOMERS_FILE, []);
        foreach ($custs as $c) {
            if ((int)($c['chat_id'] ?? 0) === $user_id) { cust_menu_main($user_id); return; }
        }
        // اگر در employees.json باشد → براساس job
        $emps = storage_load(EMPLOYEES_FILE, []);
        foreach ($emps as $e) {
            if ((int)($e['chat_id'] ?? 0) === $user_id) {
                $job = strtolower((string)($e['job'] ?? ''));
                if ($job === 'مدیردپارتمان' || $job === 'manager' || $job === 'مدیر' || $job === 'مدیر دپارتمان') {
                    mgr_menu_main($user_id); return;
                }
                // سایر مشاغل فعلاً با منوی وظایف باز می‌شوند
                emp_menu($user_id, $user_id); 
                return;
            }
        }
        // پیش‌فرض
        tg_send_html($user_id, "حساب شما هنوز به شغلی منتسب نشده. لطفاً منتظر تأیید حسابداری بمانید.");
    }
}

/** دستورات متنی مدیرعامل */
if (!function_exists('admin_handle_text')) {
    function admin_handle_text(int $chat_id, int $user_id, string $text): bool {
        if ($user_id !== CEO_UID) return false;

        $t = trim($text);

        // 1) تعیین شغل پرسنل: /setjob 162160538 مدیردپارتمان
        if (preg_match('~^/setjob\s+(\d+)\s+(.+)$~u', $t, $m)) {
            $uid  = (int)$m[1];
            $job  = trim($m[2]);
            $emps = storage_load(EMPLOYEES_FILE, []);
            $found = false;
            foreach ($emps as &$e) {
                if ((int)($e['chat_id'] ?? 0) === $uid) { $e['job'] = $job; $found = true; break; }
            }
            if (!$found) $emps[] = ['chat_id' => $uid, 'full_name' => '', 'job' => $job, 'created_ts' => time()];
            storage_save(EMPLOYEES_FILE, $emps);
            tg_send_html($chat_id, "✅ شغل کاربر ".to_persian_num($uid)." → «".tg_escape($job)."» ذخیره شد.");
            tg_send_html($uid, "🌟 شغل شما در سیستم: «{$job}». پنل شما فعال شد.");
            open_user_panel($uid);
            return true;
        }

        // 2) افزودن سرویس فروشگاه: /svc_add عنوان|قیمت
        if (str_starts($t, '/svc_add')) {
            $line = trim(mb_substr($t, 8));
            if (!str_contains($line, '|')) { tg_send_html($chat_id, "قالب: <code>/svc_add طراحی لوگو|25000000</code>"); return true; }
            [$title, $price] = array_map('trim', explode('|', $line, 2));
            $id = svc_add($title, (int)$price);
            tg_send_html($chat_id, "✅ سرویس «".tg_escape($title)."» با قیمت ".money((int)$price)." (ID #".to_persian_num($id).") افزوده شد.");
            return true;
        }

        // 3) ساخت مشتری آزمایشی + تیم: /seed_demo @handle 894457439|162160538|287098219|620344705|X|X
        if (str_starts($t, '/seed_demo')) {
            $line = trim(mb_substr($t, 10));
            if (!preg_match('~^(@\S+)\s+([\d|Xx]+)$~u', $line, $m)) {
                tg_send_html($chat_id, "قالب: <code>/seed_demo @page  manager|scenarist|blogger|videographer|editor|admin</code>\n"
                    ."برای آی‌دی ناموجود حرف X بزنید.");
                return true;
            }
            $handle = $m[1];
            $ids = array_map('trim', explode('|', $m[2]));
            $cust_id = random_int(100000000, 999999999);
            $custs = storage_load(CUSTOMERS_FILE, []);
            $custs[] = ['chat_id'=>$cust_id, 'brand'=>'DemoBrand', 'instagram'=>$handle, 'created_ts'=>time()];
            storage_save(CUSTOMERS_FILE, $custs);

            $team = ['manager'=>0,'scenarist'=>0,'blogger'=>0,'videographer'=>0,'editor'=>0,'admin'=>0];
            $keys = array_keys($team);
            foreach ($keys as $k => $role) {
                if (!isset($ids[$k])) continue;
                $val = strtoupper($ids[$k]) === 'X' ? 0 : (int)$ids[$k];
                $team[$role] = $val;
            }
            dept_assign_team($cust_id, $team);
            tg_send_html($chat_id, "✅ مشتری دمو (#".to_persian_num($cust_id).") با تیم اولیه ثبت شد.");
            return true;
        }

        // 4) باز کردن پنل هر کاربر: /open 162160538
        if (preg_match('~^/open\s+(\d+)$~', $t, $m)) {
            $uid = (int)$m[1];
            open_user_panel($uid);
            tg_send_html($chat_id, "✅ پنل کاربر ".to_persian_num($uid)." ارسال شد.");
            return true;
        }

        // 5) ثبت آفیش سریع: /offish customerId 1404/06/20 14:30 آدرس | لوکیشن | @handle [extra]
        if (str_starts($t, '/offish ')) {
            $line = trim(mb_substr($t, 8));
            $parts = array_map('trim', explode('|', $line));
            if (count($parts) < 3) { 
                tg_send_html($chat_id, "قالب: <code>/offish customerId 1404/06/20 14:30 آدرس | لوکیشن | @handle [extra]</code>");
                return true;
            }
            // بخش اول قبل از | شامل سه قطعه‌ست
            $head = preg_split('~\s+~', $parts[0]);
            if (count($head) < 3) { tg_send_html($chat_id, "قالب بخش اول: <code>customerId YYYY/MM/DD HH:MM</code>"); return true; }

            $cust = (int)$head[0];
            $date = $head[1];
            $hour = $head[2];
            $addr = trim($parts[1] ?? '');
            $loc  = trim($parts[2] ?? '');
            $hand = trim($parts[3] ?? '');
            $extra = isset($parts[4]) && stripos($parts[4], 'extra') !== false;

            $id = offish_create($cust, $chat_id, $date, $hour, $addr, $loc, $hand, $extra);
            tg_send_html($chat_id, $id ? "✅ آفیش #".to_persian_num($id)." ثبت شد." : "⛔️ ثبت آفیش انجام نشد.");
            return true;
        }

        // 6) راهنمای دستورات
        if ($t === '/help' || $t === '/admin') {
            tg_send_html($chat_id,
                "دستورات مدیرعامل:\n".
                "• <code>/setjob userId شغل</code>\n".
                "• <code>/svc_add عنوان|قیمت</code>\n".
                "• <code>/seed_demo @handle  manager|scenarist|blogger|videographer|editor|admin</code>\n".
                "• <code>/open userId</code>\n".
                "• <code>/offish customerId YYYY/MM/DD HH:MM آدرس | لوکیشن | @handle [extra]</code>\n"
            );
            return true;
        }

        return false;
    }
}

return true;
