<?php
declare(strict_types=1);

/**
 * ورود نقش‌ها و جریان تکمیل پروفایل اولیه
 */

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/storage.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../config/env.php';

function auth_handle_role_entry(int $chat_id, string $role): void {
    if ($role === 'employee') {
        $msg = "درخواست کارمند جدید ✅\nآی‌دی: ".to_persian_num($chat_id)."\nلطفاً اطلاعات پرسنلی را تکمیل کنید.";
        tg_send_html(CEO_UID, $msg);
        tg_send_html($chat_id, "درخواست شما ثبت شد ✅\nهمکار عزیز؛ حسابداری بزودی اطلاعات پروفایل شما را کامل می‌کند. سپس برای تأیید نهایی به شما پیام می‌دهیم ✨");
        // درج حداقلی در employees.json
        $emps = storage_load(EMPLOYEES_FILE, []);
        $exists = false; foreach ($emps as $e) if ((int)($e['chat_id']??0)===$chat_id) { $exists=true; break; }
        if (!$exists) { $emps[] = ['chat_id'=>$chat_id,'full_name'=>'','job'=>'','created_ts'=>time()]; storage_save(EMPLOYEES_FILE, $emps); }
        return;
    }
    if ($role === 'customer') {
        $msg = "درخواست مشتری جدید ✅\nآی‌دی: ".to_persian_num($chat_id)."\nلطفاً اطلاعات قرارداد/برند را تکمیل کنید.";
        tg_send_html(CEO_UID, $msg);
        tg_send_html($chat_id, "درخواست شما ثبت شد ✅\nحسابداری اطلاعات شما را تکمیل می‌کند؛ سپس پنل مشتری فعال می‌شود ✨");
        $custs = storage_load(CUSTOMERS_FILE, []);
        $exists=false; foreach($custs as $c) if ((int)($c['chat_id']??0)===$chat_id) {$exists=true;break;}
        if(!$exists){ $custs[]=['chat_id'=>$chat_id,'brand'=>'','instagram'=>'','created_ts'=>time()]; storage_save(CUSTOMERS_FILE,$custs); }
        return;
    }
}
