<?php
declare(strict_types=1);

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/storage.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../config/env.php';

if (!defined('PENAL_FILE'))     define('PENAL_FILE',     VM_STORAGE . '/penalties.json');
if (!defined('EMPLOYEES_FILE')) define('EMPLOYEES_FILE', VM_STORAGE . '/employees.json');

function pen_all(): array { return storage_load(PENAL_FILE, []); }
function pen_save_all(array $arr): bool { return storage_save(PENAL_FILE, $arr); }
function pen_find(int $id): ?array { foreach(pen_all() as $p) if((int)$p['id']===$id) return $p; return null; }

function pen_submit_manual(int $target_user_id, int $amount, string $reason, int $created_by, ?array $ref=null, ?array $evidence=null, string $created_role='dept_manager'): int {
    $all=pen_all(); $id=(count($all)? max(array_column($all,'id')):0)+1;
    $item=['id'=>$id,'user_id'=>$target_user_id,'amount'=>$amount,'reason'=>$reason,'ts'=>time(),'ref'=>$ref,'evidence'=>$evidence,'created_by'=>$created_by,'created_role'=>$created_role,'auto'=>false,'state'=>'submitted'];
    $all[]=$item; pen_save_all($all);
    $kb = kb_inline([[ kb_btn('✅ تایید حسابداری', "pen:acct:ok:{$id}"), kb_btn('❌ رد', "pen:acct:no:{$id}") ]]);
    $card = pen_render_card($item, 'در انتظار تایید حسابداری');
    tg_send_kb_html(CEO_UID, $card, $kb);
    tg_send_html($created_by, "✅ جریمه ثبت شد و برای حسابداری ارسال گردید. (#".to_persian_num($id).")");
    return $id;
}
function pen_render_card(array $p, string $stateLabel=''): string {
    $uid=to_persian_num((int)($p['user_id']??0)); $amt=money((int)($p['amount']??0)); $rsn=tg_escape($p['reason']??'—');
    $state=$stateLabel? "وضعیت: <b>{$stateLabel}</b>\n":''; return "⚠️ <b>کارت جریمه</b>\nکارمند: <code>{$uid}</code>\nمبلغ: <b>{$amt}</b>\nدلیل: {$rsn}\n{$state}";
}
function pen_render_notice_for_employee(array $p, string $name='همکار عزیز'): string {
    $tmpl=PENALTY_TEMPLATE;
    return str_replace(['{date}','{name}','{reason}','{amount}'], [vm_now('Y-m-d H:i'), tg_escape($name), tg_escape($p['reason']??''), to_persian_num((int)($p['amount']??0))], $tmpl);
}
function pen_apply_to_employee_profile(int $user_id, array $pen): void {
    $emps=storage_load(EMPLOYEES_FILE,[]); $found=false;
    foreach($emps as &$e){ if((int)($e['chat_id']??0)===$user_id){ $ded=$e['deductions']??[]; $ded[]=['penalty_id'=>(int)$pen['id'],'amount'=>(int)$pen['amount'],'reason'=>(string)($pen['reason']??''),'ts'=>time()]; $e['deductions']=$ded; $found=true; break; } }
    if(!$found){ $emps[]=['chat_id'=>$user_id,'full_name'=>'','job'=>'','deductions'=>[['penalty_id'=>(int)$pen['id'],'amount'=>(int)$pen['amount'],'reason'=>(string)($pen['reason']??''),'ts'=>time()]],'created_ts'=>time()]; }
    storage_save(EMPLOYEES_FILE,$emps);
}
function pen_acct_decide(int $pen_id, bool $ok): bool {
    $all=pen_all(); foreach($all as &$p){ if((int)$p['id']!==$pen_id) continue;
        if($p['state']!=='submitted'){ return false; }
        if(!$ok){ $p['state']='rejected'; pen_save_all($all); $by=(int)($p['created_by']??0); if($by) tg_send_html($by,"⛔️ جریمه #".to_persian_num($pen_id)." توسط حسابداری رد شد."); return true; }
        $p['state']='acct_ok'; pen_save_all($all);
        $kb = kb_inline([[ kb_btn('✅ تایید مدیرعامل', "pen:ceo:ok:{$pen_id}"), kb_btn('❌ رد', "pen:ceo:no:{$pen_id}") ]]);
        tg_send_kb_html(CEO_UID, pen_render_card($p,'تایید حسابداری؛ منتظر تایید مدیرعامل'), $kb);
        return true;
    } return false;
}
function pen_ceo_decide(int $pen_id, bool $ok): bool {
    $all=pen_all(); foreach($all as &$p){ if((int)$p['id']!==$pen_id) continue;
        if(!$ok){ $p['state']='rejected'; pen_save_all($all); $by=(int)($p['created_by']??0); if($by) tg_send_html($by,"⛔️ جریمه #".to_persian_num($pen_id)." توسط مدیرعامل رد شد."); return true; }
        $p['state']='ceo_ok'; $p['applied_ts']=time(); pen_save_all($all);
        pen_apply_to_employee_profile((int)$p['user_id'],$p);
        $notice = pen_render_notice_for_employee($p,'همکار عزیز'); tg_send_html((int)$p['user_id'], nl2br($notice));
        $by=(int)($p['created_by']??0); if($by) tg_send_html($by,"✅ جریمه #".to_persian_num($pen_id)." تایید و اعمال شد.");
        tg_send_html(CEO_UID,"✅ اعمال شد: جریمه #".to_persian_num($pen_id)." / کاربر ".to_persian_num((int)$p['user_id'])." / مبلغ ".money((int)$p['amount']));
        return true;
    } return false;
}
function pen_handle_callback(int $chat_id, int $user_id, string $data): bool {
    if (!str_starts($data,'pen:')) return false;
    if (preg_match('~^pen:ceo:(ok|no):(\d+)$~',$data,$m)){ if($user_id!==CEO_UID){ tg_send_html($chat_id,'❌ فقط مدیرعامل.'); return true; } $ok=$m[1]==='ok'; $pid=(int)$m[2]; $res=pen_ceo_decide($pid,$ok); tg_send_html($chat_id, $res? ($ok?'✅ تایید شد.':'❌ رد شد.'):'⛔️ خطا.'); return true; }
    if (preg_match('~^pen:acct:(ok|no):(\d+)$~',$data,$m)){ $ok=$m[1]==='ok'; $pid=(int)$m[2]; $res=pen_acct_decide($pid,$ok); tg_send_html($chat_id,$res?($ok?'✅ تایید حسابداری شد.':'❌ رد شد.'):'⛔️ خطا.'); return true; }
    return false;
}

return true;
