CREATE TABLE IF NOT EXISTS vm_users (
  chat_id BIGINT PRIMARY KEY,
  role VARCHAR(32) NOT NULL,        -- ceo|employee|customer|manager|accountant|...
  full_name VARCHAR(120) DEFAULT '',
  created_ts INT NOT NULL
);

CREATE TABLE IF NOT EXISTS vm_employees (
  chat_id BIGINT PRIMARY KEY,
  full_name VARCHAR(120) DEFAULT '',
  job VARCHAR(64) DEFAULT '',
  meta JSON NULL,
  created_ts INT NOT NULL
);

CREATE TABLE IF NOT EXISTS vm_customers (
  chat_id BIGINT PRIMARY KEY,
  brand VARCHAR(120) DEFAULT '',
  instagram VARCHAR(120) DEFAULT '',
  meta JSON NULL,
  team JSON NULL,
  created_ts INT NOT NULL
);

CREATE TABLE IF NOT EXISTS vm_services (
  id INT AUTO_INCREMENT PRIMARY KEY,
  title VARCHAR(160) NOT NULL,
  price INT NOT NULL,
  `desc` TEXT NULL,
  photo_url TEXT NULL,
  created_ts INT NOT NULL
);

CREATE TABLE IF NOT EXISTS vm_invoices (
  id INT AUTO_INCREMENT PRIMARY KEY,
  customer_chat_id BIGINT NOT NULL,
  items JSON NOT NULL,
  amount_total INT NOT NULL,
  amount_paid INT NOT NULL DEFAULT 0,
  latefee_total INT NOT NULL DEFAULT 0,
  status ENUM('unpaid','partial','paid') NOT NULL DEFAULT 'unpaid',
  created_ts INT NOT NULL,
  due_ts INT NOT NULL,
  INDEX idx_cust(customer_chat_id)
);

CREATE TABLE IF NOT EXISTS vm_tasks (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id BIGINT NOT NULL,
  chat_id BIGINT NOT NULL,
  title VARCHAR(200) NOT NULL,
  `desc` TEXT NULL,
  due_ts INT NOT NULL,
  job VARCHAR(64) NULL,
  status ENUM('open','done','cancel') NOT NULL DEFAULT 'open',
  created_ts INT NOT NULL,
  done_ts INT NULL,
  tags JSON NULL,
  INDEX idx_user(user_id), INDEX idx_status(status), INDEX idx_due(due_ts)
);

CREATE TABLE IF NOT EXISTS vm_penalties (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id BIGINT NOT NULL,
  amount INT NOT NULL,
  reason TEXT NOT NULL,
  ts INT NOT NULL,
  ref JSON NULL,
  auto TINYINT(1) NOT NULL DEFAULT 0,
  state ENUM('submitted','acct_ok','ceo_ok','approved','rejected') NOT NULL DEFAULT 'submitted',
  created_by BIGINT NULL,
  created_role VARCHAR(64) NULL,
  applied_ts INT NULL,
  INDEX idx_user(user_id)
);

CREATE TABLE IF NOT EXISTS vm_shoots (
  id INT AUTO_INCREMENT PRIMARY KEY,
  customer_chat_id BIGINT NOT NULL,
  manager_id BIGINT NOT NULL,
  blogger_id BIGINT NULL,
  videographer_id BIGINT NULL,
  date_ts INT NOT NULL,
  hour VARCHAR(10) NOT NULL,
  address TEXT NOT NULL,
  location TEXT NOT NULL,
  ig_handle VARCHAR(120) NOT NULL,
  status ENUM('pending','confirmed','rejected','done') NOT NULL DEFAULT 'pending',
  blogger_accept TINYINT(1) NULL,
  videographer_accept TINYINT(1) NULL,
  enter_ts INT NULL,
  exit_ts INT NULL,
  content_calendar JSON NULL,
  INDEX idx_cust(customer_chat_id), INDEX idx_mgr(manager_id), INDEX idx_date(date_ts)
);

CREATE TABLE IF NOT EXISTS vm_queue (
  id INT AUTO_INCREMENT PRIMARY KEY,
  type VARCHAR(64) NOT NULL,
  run_at_ts INT NOT NULL,
  payload JSON NULL,
  created_ts INT NOT NULL,
  INDEX idx_run(run_at_ts)
);
