<?php
declare(strict_types=1);

/**
 * Vision Media Bot — handlers/start.php
 * نقطه شروع /start برای همه کاربران
 */

function handle_start(int $chat_id, int $from_id, array $user): void {
    users_seed_from_config();

    $role = $user['role'] ?? null;
    if (!$role) {
        // اگر درخواستی ارسال شده و هنوز pending است
        $pend = approvals_by_target($from_id);
        foreach ($pend as $p) {
            if (($p['type'] ?? '')==='role_req' && ($p['status'] ?? '')==='pending') {
                tg_send_html($chat_id,
                    vm_polite_header($user['full_name'])
                    ."درخواست نقش شما ثبت شده و نزد حسابداری در حال بررسی است ✅\n"
                    ."به‌محض تایید، دسترسی پنل فعال می‌شود.");
                return;
            }
        }
        // هنوز درخواستی ثبت نشده → انتخاب نقش
        $rows = [
            [kb_btn(icon('employee')." کارمند هستم", "emp:req")],
            [kb_btn(icon('customer')." مشتری هستم", "cust:req")],
        ];
        tg_send_kb_html($chat_id,
            vm_polite_header($user['full_name'])
            ."به <b>ویژن مدیا</b> خوش اومدی ✨\n"
            ."برای ادامه یکی از گزینه‌ها را انتخاب کن:",
            kb_inline($rows)
        );
        return;
    }

    // نقش دارد → هدایت به پنل
    route_to_panel($chat_id, $user);
}
