<?php
declare(strict_types=1);
require_once __DIR__ . '/storage.php';

if (!defined('SETTINGS_FILE')) {
    define('SETTINGS_FILE', STORAGE_DIR . '/settings.json');
}

if (!function_exists('settings_all')) {
function settings_all(): array {
    $j = storage_read_json(SETTINGS_FILE);
    if (!is_array($j)) $j = [];
    // defaults
    $defaults = [
        'late_fee_per_day' => 150000,
        'offish_quota_per_month' => 3,
        'auto_reports_enabled' => true,
        'workday_end_hour' => 23, // 11PM deadline for tasks
        'greeting_style' => 'friendly', // friendly|formal
        'company_name' => 'ویژن مدیا',
        'company_legal' => 'البرز مدیا دوراندیش',
        'company_regno' => '۴۲۵۶۳',
        'company_nid' => '۱۴۰۱۱۱۲۸۲۲۲',
        'company_address' => 'کرج ، جهانشهر، میدان سپاه ، مجتمع تجاری گلستان',
        'company_phones' => ['09331903872','09981381737','02634425880','02191305883'],
        'website' => 'www.visionmedia.ir'
    ];
    foreach ($defaults as $k=>$v) if (!array_key_exists($k,$j)) $j[$k]=$v;
    return $j;
}}

if (!function_exists('settings_save')) {
function settings_save(array $cfg): bool {
    return storage_write_json(SETTINGS_FILE, $cfg);
}}

if (!function_exists('settings_set')) {
function settings_set(string $key, $value): bool {
    $cfg = settings_all();
    $cfg[$key] = $value;
    return settings_save($cfg);
}}

if (!function_exists('settings_get')) {
function settings_get(string $key, $default=null) {
    $cfg = settings_all();
    return array_key_exists($key,$cfg) ? $cfg[$key] : $default;
}}
