<?php
declare(strict_types=1);
require_once __DIR__ . '/../functions/telegram.php';
require_once __DIR__ . '/../functions/utils.php';
require_once __DIR__ . '/../functions/storage.php';
function emp_menu(int $chat_id): void {
    $rows = [
        [ kb_btn(icon('leave')." درخواست مرخصی", 'emp:leave') ],
        [ kb_btn('وظیفه‌های من ✅', 'emp:tasks') ],
        [ kb_btn(icon('camera').' راهنمای فایل خام', 'emp:raw:help') ],
        [ kb_btn(icon('back')." خانه", 'back:home') ],
    ];
    tg_send_html($chat_id, friendly_greeting()."\n\n".icon('employee')." <b>پنل کارمند</b>", $rows);
}
function emp_handle(string $data, int $chat_id): void {
    if ($data === 'emp:menu') { emp_menu($chat_id); return; }
    if ($data === 'emp:leave') {
        $leaves = leaves_all();
        $leaves[] = ['id'=>count($leaves)+1,'user_id'=>$chat_id,'status'=>'pending_dm','created_at'=>time()];
        leaves_save($leaves);
        tg_send_html($chat_id, friendly_greeting()."\n\n".icon('ok')." مرخصی ثبت شد (در انتظار مدیر دپارتمان).");
    } elseif ($data === 'emp:raw:help') {
        tg_send_html($chat_id, friendly_greeting()."\n\n"."فعلاً فایل ZIP را برای مدیر دپارتمان ارسال کنید. ماژول خودکارسازی کانال قابل افزودن است.");
    }
}


require_once __DIR__ . '/../functions/tasks.php';

function emp_tasks_list(int $chat_id): void {
    $items = task_list_for($chat_id);
    if (!$items) { tg_send_html($chat_id, "فعلاً وظیفه‌ای نداری ✌️"); return; }
    $lines = array_map(fn($t)=>"#{$t['id']} — {$t['title']} — موعد: ".date('Y-m-d H:i',$t['due_ts'])." — وضعیت: {$t['status']}", $items);
    $txt = "<b>وظیفه‌های من</b>\n" . implode("\n", $lines);
    $kb = [];
    foreach ($items as $t) { if (($t['status']??'')==='pending') $kb[] = [ kb_btn("تمام شد: #".$t['id'], "emp:task:done:".$t['id']) ]; }
    if (!$kb) $kb = [[ kb_btn(icon('back')." بازگشت", 'emp:menu') ]];
    tg_send_html($chat_id, $txt, $kb);
}

function emp_handle_plus(string $data, int $chat_id): bool {
    if ($data==='emp:tasks') { emp_tasks_list($chat_id); return true; }
    if (strpos($data,'emp:task:done:')===0) {
        $id = (int)substr($data, strstrlen('emp:task:done:'));
        task_set_status($id, 'done');
        tg_send_html($chat_id, "✅ وظیفه #$id انجام شد.");
        return true;
    }
    return False;
}
