<?php
header('Content-Type: text/plain; charset=utf-8');
$base = dirname(__DIR__).'/bot';
function line($k,$v){ echo str_pad($k,28,'.').' '.$v."\n"; }
line('php_sapi_name()', php_sapi_name());
line('PHP_VERSION', PHP_VERSION);
line('display_errors', ini_get('display_errors'));
line('log_errors', ini_get('log_errors'));
line('timezone', date_default_timezone_get());
// Files
$paths=['storage/config.json','storage/owners.json','handlers/start.php','handlers/start_fallback.php','index.php'];
foreach($paths as $p){ $f=$base.'/'.$p; line('file: '.$p, (is_file($f)?'OK':'missing')); }
// config
$cfg=@json_decode(@file_get_contents($base.'/storage/config.json'),true);
line('config.json loaded', is_array($cfg)?'YES':'NO');
if(is_array($cfg)){
  line('bot_token len', isset($cfg['bot_token'])?strlen($cfg['bot_token']):0);
  line('webhook_url', $cfg['webhook_url']??'-');
}
// owners
$own=@json_decode(@file_get_contents($base.'/storage/owners.json'),true);
line('owners.json loaded', is_array($own)?'YES':'NO');
line('CEO count', is_array($own)&&isset($own['ceo_ids'])?count($own['ceo_ids']):0);
// functions
$fn=['start_menu','start_handle','ceo_plus_menu','acc_menu','acc_handle','tg_send_html'];
foreach($fn as $f){ line('function '.$f, function_exists($f)?'YES':'no'); }
// webhook last lines
$log=$base.'/storage/logs/webhook.log';
if(is_file($log)){
  echo "\n--- last 20 lines from webhook.log ---\n";
  $lines=@file($log); $tail=array_slice($lines,-20);
  echo implode('', $tail);
}else echo "\n(no webhook.log yet)\n";
?>