<?php
declare(strict_types=1);

require_once __DIR__ . '/../core/utils.php';
require_once __DIR__ . '/../core/storage.php';
require_once __DIR__ . '/../core/telegram.php';
require_once __DIR__ . '/../core/scheduler.php';
require_once __DIR__ . '/../config/env.php';

if (!defined('TASKS_FILE')) define('TASKS_FILE', VM_STORAGE . '/tasks.json');

// مدل
function task_list(): array { return storage_load(TASKS_FILE, []); }
function task_find(int $id): ?array { foreach (task_list() as $t) if ((int)$t['id']===$id) return $t; return null; }
function task_save_all(array $arr): bool { return storage_save(TASKS_FILE, $arr); }

// ساخت
function task_create(int $user_id, string $title, string $desc, int $due_ts, ?string $job=null, ?int $chat_id=null): int {
    $all = task_list();
    $id = (count($all)? max(array_column($all,'id')) : 0) + 1;
    $item = ['id'=>$id,'user_id'=>$user_id,'chat_id'=>$chat_id??$user_id,'title'=>$title,'desc'=>$desc,'due_ts'=>$due_ts,'job'=>$job,'status'=>'open','created_ts'=>time(),'remind_ids'=>[],'tags'=>[]];
    $all[]=$item; task_save_all($all);
    $kb = yesno_btns("emp:task:done:{$id}", "emp:task:noop:{$id}");
    $msg = "🆕 <b>وظیفه جدید</b>\n«".tg_escape($title)."»\nمهلت: <b>".jdate('Y/m/d H:i',$due_ts)."</b>\nوقتی انجام شد «✅ تایید» بزن.";
    tg_send_kb_html($item['chat_id'], $msg, $kb);
    return $id;
}
function task_update(int $id, array $patch): bool {
    $all = task_list();
    foreach ($all as &$t) if ((int)$t['id']===$id) { $t = array_merge($t,$patch); return task_save_all($all); }
    return false;
}
function task_mark_done(int $id): bool { return task_update($id, ['status'=>'done','done_ts'=>time()]); }

function task_for_scenarist(int $uid, string $title, string $desc=''): int {
    $due = time() + SCENARIO_DEADLINE_HOURS*3600; return task_create($uid,$title,$desc,$due,'scenario');
}
function task_for_videographer(int $uid, string $title, string $desc=''): int {
    $due = time() + VIDEOGRAPHER_DEADLINE_HOURS*3600; return task_create($uid,$title,$desc,$due,'videographer');
}
function task_for_editor(int $uid, string $title, string $kind='check_files', string $desc=''): int {
    $hours = ($kind==='check_files')? EDITOR_CHECK_DEADLINE_HOURS : EDITOR_FIRST_VIDEO_DEADLINE_HOURS;
    $due = time() + $hours*3600; return task_create($uid,$title,$desc,$due,'editor');
}
function task_for_admin_content(int $uid, string $title, string $desc='', ?int $ts_day=null): int {
    $ts_day = $ts_day ?? time(); $y=date('Y',$ts_day); $m=date('m',$ts_day); $d=date('d',$ts_day);
    $due = mktime(23,0,0,(int)$m,(int)$d,(int)$y);
    return task_create($uid,$title,$desc,$due,'admin');
}

function task_render_reminder(array $task, int $hours_left): string {
    $ttl=tg_escape($task['title']??'—'); $due=(int)($task['due_ts']??0);
    return "⏰ یادآوری: فقط ".to_persian_num($hours_left)." ساعت مانده\n«{$ttl}»\nمهلت: <b>".jdate('Y/m/d H:i',$due)."</b>";
}

// روتر مدیریتی نمونه
function tasks_handle_callback(int $chat_id, int $user_id, string $data): bool {
    if (!str_starts($data, 'mgr:task:')) return false;
    if (preg_match('~^mgr:task:new:(\d+)$~',$data,$m)) {
        $id = task_create((int)$m[1], 'وظیفه نمونه', 'این یک تست است', time()+3600, 'admin', (int)$m[1]);
        tg_send_html($chat_id, '✅ وظیفه ساخته شد: #'.to_persian_num($id));
        return true;
    }
    return false;
}

return true;
